from api import *
from deplacement import *
from lien import *

from math import ceil

# formats d'actions :
# { "type" : "capture", "position" : pos }
# { "type" : "lier", "position" : pos }
# { "type" : "bouclier", "position" : pos }
# { "type" : "neutraliser", "position" : pos }
# { "type" : "turbo", "position" : pos }
# { "type" : "bouger_defaut", "position" : pos }

WORTH_TURBO = 0.01
WORTH_BOUGER_DEFAUT = 0.1

WORTH_CAPTURE_DEBUT = 1.5 # *[] au premier tour ...
WORTH_CAPTURE_SEUL = 15 # S'ajoute gain d'une capture si elle n'est pas dans un triangle
WORTH_CAPTURE_CHAMP = 50 # S'ajoute gain d'une capture si elle est dans un triangle
WORTH_SURFACE = 10 # Constante multiplication sur le gain des surfaces

WORTH_ATTAQUE_BASES = 20
WORTH_ATTAQUE_DEGATS = 10 # Constante multiplicative des points perdus a l'attaque
WORTH_ATTAQUE_GAIN = 20 # Constante multiplicative des points que l'on peut recuperer par l'attaque

WORTH_BOUCLIER_AIRE = 0.42 # Proteger les portails importants
WORTH_BOUCLIER_DISTANCE = 100 # Pour un joueur a moins de 6 cases , +[]

BLAME_DEPASSEMENT = 15
RAPPORT_DEPASSEMENT = 2 # ...**n rajoute avec turbos
RAPPORT_IMPOSSIBLES = 10

def filtrer_actions(actions) :
    """Retourne une liste d'actions plus courte
    Les actions trop eloignes ou trop couteuses sont eliminees
    """
    def garder(a) : # filtre sur une action
        return peutAller(a["position"]) and (coutAction(a) + turbos_necessaires(a["position"]))<= points_action()
    
    return [ a for a in actions if garder(a) ]

def do_action(action) :
    """Applique une action
    Retour : une liste de nouvelles actions a effectuer apres
    """
    actionsSuivantes = []
    if turbos_necessaires(action["position"]) > 0 :
        print(" * Utilisation de " + str(turbos_necessaires(action["position"])) + " turbos")
        utiliser_turbos( turbos_necessaires(action["position"]) )
    vers(action["position"])
    if distance(position_agent(moi()), action["position"]) > points_deplacement() or coutAction(action) > points_action() :
        return []
    
    if action["type"] == "capture" :
        capturer()
        toutLier() # On relie par defaut
        actionsSuivantes += [{ "type" : "bouclier", "position" : action["position"] }]
    
    elif action["type"] == "lier" :
        toutLier()
        
    elif action["type"] == "bouclier" :
        ajouter_bouclier()
        if portail_boucliers(action["position"]) < MAX_BOUCLIERS :
            actionsSuivantes += [{ "type" : "bouclier", "position" : action["position"] }]
    
    elif action["type"] == "neutraliser" :
        neutraliser()
        actionsSuivantes += [{ "type" : "capture", "position" : action["position"] }]
    
    elif action["type"] == "bouger_defaut" :
        utiliser_turbos(42)
        vers(directionSecondaire())
    
    return actionsSuivantes

def listerActions() :
    """Donne toutes les actions aui pourraient etre faitent sur la map"""
    actions = []
    # liste des portails
    for portail in liste_portails() :
        if portail_joueur(portail) == -1 : # Portails neutres
            actions += [{ "type" : "capture", "position" : portail }]
            
        elif portail_joueur(portail) == adversaire() :
            actions += [{ "type" : "neutraliser", "position" : portail }]
        
        else : # C'est mon portail
            if not( case_dans_champ(portail) ) and portail_joueur(portail) == moi() : # Portails non lies
                actions += [{ "type" : "lier", "position" : portail }]
                
            if portail_joueur(portail) == moi() and portail_boucliers(portail) < MAX_BOUCLIERS:
                actions += [{ "type" : "bouclier", "position" : portail }]
                
    actions += [{ "type" : "bouger_defaut", "position" : position_agent(moi()) }]
    return actions

def worth_of_actions(actions) : # <3 lightcaml 0.75
    worth_list = []
    for action in actions :
        worth_list += [(worth(action), action )]
    worth_list.sort(key=(lambda e : e[0]), reverse=True)
    return worth_list

def actions_of_worth(worth) : # <3 lightcaml 0.75
    return [ w[1] for w in worth ]

def gain(action) :
    """Quantifie l'apport d'une action"""
    def mul_capt_debut() :
        """En fonction du tour, multiplicative de worth"""
        return 1 + (WORTH_CAPTURE_DEBUT-1)*(1/tour_actuel())
    
    if( action["type"] == "capture" ) :
        champ = WORTH_CAPTURE_CHAMP if case_dans_champ(action["position"]) else WORTH_CAPTURE_SEUL
        return  (WORTH_SURFACE * gainAire(action["position"]) + champ) * mul_capt_debut()
    
    if( action["type"] == "lier" ) :
        return gainAire(action["position"])
    
    if( action["type"] == "bouclier" ) :
        distEnemy = distance(position_agent(adversaire()), action["position"])
        return WORTH_BOUCLIER_AIRE * scorePortail(action["position"]) + (1/(1+int(distEnemy)/6))**2 * WORTH_BOUCLIER_DISTANCE
    
    if( action["type"] == "neutraliser" ) :
        return (WORTH_ATTAQUE_BASES + WORTH_ATTAQUE_DEGATS * scorePortail(action["position"])) + WORTH_ATTAQUE_GAIN * gainAire(action["position"])
    
    return 0 # si pas de gain defini -> definis dans worth
    
def coutAction(action) :
    """Retourne le cout de l'action"""
    cout = 0
    if( action["type"] == "capture" ) :
        cout += COUT_CAPTURE
    if( action["type"] == "lier" ) :
        cout += COUT_LIEN
    if( action["type"] == "bouclier" ) :
        cout += COUT_BOUCLIER + portail_boucliers(action["position"])
    if( action["type"] == "neutraliser" ) :
        cout += COUT_NEUTRALISATION + portail_boucliers(action["position"])*COUT_NEUTRALISATION_BOUCLIER
    if( action["type"] == "turbo" ) :
        cout += COUT_TURBO
    return cout

def coutDeplacement(action) :
    """Calcul de cout du deplacement de la case actuelle vers la position donnee
       2 * mouvements + le cout en turbo"""
    if action["type"] == "turbo" or action["type"] == "bouger_defaut" :
        return 0 # Toutes les actions qui ne sont pas vraiment liees a une case
    
    position = action["position"]
    dist = distance( position_agent(moi()), position )
    cout = dist
    if dist > points_deplacement() :
        avec_turbo = min(4, dist - points_deplacement())
        impossible = dist - points_deplacement() - avec_turbo
        cout += RAPPORT_DEPASSEMENT ** avec_turbo + RAPPORT_IMPOSSIBLES * ceil( impossible / 10) + BLAME_DEPASSEMENT
    return cout

def worth(action) :
    """Donne le quotient de worth d'une action"""
    if( action["type"] == "turbo" ) :
        return WORTH_TURBO
    elif( action["type"] == "bouger_defaut" ) :
        return WORTH_BOUGER_DEFAUT
    else :
        return gain(action)/(coutDeplacement(action)+coutAction(action))

def string_of_action(action) : # <3 lightcaml 0.75
    """Cree une chaine de caractere de qualite decrivant l'action"""
    if action["type"] == "turbo" :
        return "Utiliser un turbo"
    elif action["type"] == "bouger_defaut" :
        return "Deplacement vers la direction par defaut"
    message = ""
    if action["type"] == "capture" :
        message += "Capturer la case     "
    if action["type"] == "lier" :
        message += "Relier la case       "
    if action["type"] == "bouclier" :
        message += "Creer un bouclier en "
    if action["type"] == "neutraliser" :
        message += "Attaquer la case     "
    message += str( action["position"] )
    return message